/****************************************************************************
*
*    The MIT License (MIT)
*
*    Copyright (c) 2014 - 2021 Vivante Corporation
*
*    Permission is hereby granted, free of charge, to any person obtaining a
*    copy of this software and associated documentation files (the "Software"),
*    to deal in the Software without restriction, including without limitation
*    the rights to use, copy, modify, merge, publish, distribute, sublicense,
*    and/or sell copies of the Software, and to permit persons to whom the
*    Software is furnished to do so, subject to the following conditions:
*
*    The above copyright notice and this permission notice shall be included in
*    all copies or substantial portions of the Software.
*
*    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
*    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
*    DEALINGS IN THE SOFTWARE.
*
*****************************************************************************
*
*    The GPL License (GPL)
*
*    Copyright (C) 2014 - 2021 Vivante Corporation
*
*    This program is free software; you can redistribute it and/or
*    modify it under the terms of the GNU General Public License
*    as published by the Free Software Foundation; either version 2
*    of the License, or (at your option) any later version.
*
*    This program is distributed in the hope that it will be useful,
*    but WITHOUT ANY WARRANTY; without even the implied warranty of
*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*    GNU General Public License for more details.
*
*    You should have received a copy of the GNU General Public License
*    along with this program; if not, write to the Free Software Foundation,
*    Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*
*****************************************************************************
*
*    Note: This software is released under dual MIT and GPL licenses. A
*    recipient may use this file under the terms of either the MIT license or
*    GPL License. If you wish to use only one license not the other, you can
*    indicate your decision by deleting one of the above license notices in your
*    version of this file.
*
*****************************************************************************/


#ifndef __gc_hal_kernel_hardware_func_flop_reset_config_h_
#define __gc_hal_kernel_hardware_func_flop_reset_config_h_

#include "gc_hal.h"

/*
 * Flop reset.
 *
 * The flops can be reset with PPU, NN and TP programs.
 * PPU:
 *   Requirements:
 *   1. DP inst with all bins enabled.
 *   2. Load inst which has at least two shader group,
 *      and every thread should load from different 64-byte address.
 *   3. Stroe inst which has at least 6 threads, whose addresses are
 *      from different 64-byte address and flush.
 *   Case:
 *   * InImage: 64x6 = {1}, unsigned int8
 *   * OutImage: 64x6, unsigned int8
 *   * OutImage = InImage + InImage
 * NN:
 *   Requirements:
 *   1. A XYDP6 case.
 *   2. NN cmd that uses only 1 core and make othere core's kernel size
 *      to be 0.
 *   Case:
 *   * Input: 3x2x1 = {1}
 *   * Kernel: 2x2x1 = {1}
 *   * Output: 2x1x1
 * TP:
 *   Requirements:
 *   1. Run TP fc on all TP cores.
 *   Case:
 *   * Input: 1x1x2 = {1}
 *   * Kernel: 1x1x2x64 = {1}
 *   * Output: 1x64
 */

/*
 * Commment: 0x85 WAR does not follow the settings.
 */

#define PPU_IMAGE_XSIZE 64
#define PPU_IMAGE_YSIZE 6
#define PPU_IMAGE_DATA 0x01010101
#define MAX_PPU_INSTRUCTION_COUNT 16
#define MAX_PPU_COMMAND_NUM 128
#define NN_INSTRUCTION_LEN 128
#define NN_INSTRUCTION_LEN_EXT 192
#define TP_INSTRUCTION_LEN 128

#define GCREG_SH_INSTRUCTION_TYPE_INVALID (~0U)

typedef enum _gceFLOP_RESET_PPU_DATA {
    gcvFLOP_RESET_PPU_INSTRUCTION = 0,
    gcvFLOP_RESET_PPU_INPUT       = 1,
    gcvFLOP_RESET_PPU_OUTPUT      = 2,
    gcvFLOP_RESET_PPU_DATA_NUM
}
gceFLOP_RESET_PPU_DATA;

/*
 * NN convolution.
 */
#define MAX_NN_COMMAND_NUM 192

#define NN_KERNEL_XSIZE 2
#define NN_KERNEL_YSIZE 2
#define NN_KERNEL_ZSIZE 1

#define NN_INPUT_XSIZE 3
#define NN_INPUT_YSIZE 2
#define NN_INPUT_ZSIZE 1

#define NN_OUTPUT_XSIZE 2
#define NN_OUTPUT_YSIZE 1
#define NN_OUTPUT_ZSIZE 1

typedef enum _gceVIP_ARCH_TYPE {
    gcvVIP_ARCH_TYPE_V6,
    gcvVIP_ARCH_TYPE_V7,
    gcvVIP_ARCH_TYPE_V8
}
gceVIP_ARCH_TYPE;

typedef enum _gceFLOP_RESET_NN_DATA {
    gcvFLOP_RESET_NN_INSTRUCTION = 0,
    gcvFLOP_RESET_NN_INPUT       = 1,
    gcvFLOP_RESET_NN_OUTPUT      = 2,
    gcvFLOP_RESET_NN_KERNEL      = 3,
    gcvFLOP_RESET_NN_DATA_NUM
}
gceFLOP_RESET_NN_DATA;

#define TP_KERNEL_XSIZE 1
#define TP_KERNEL_YSIZE 1
#define TP_KERNEL_ZSIZE 2
#define TP_KENREL_UNITS 64

#define TP_INPUT_XSIZE 1
#define TP_INPUT_YSIZE 1
#define TP_INPUT_ZSIZE 2

#define TP_OUTPUT_XSIZE 1
#define TP_OUTPUT_YSIZE 64
#define TP_OUTPUT_ZSIZE 1

typedef enum _gceFLOP_RESET_TP_DATA {
    gcvFLOP_RESET_TP_INSTRUCTION = 0,
    gcvFLOP_RESET_TP_INPUT       = 1,
    gcvFLOP_RESET_TP_OUTPUT      = 2,
    gcvFLOP_RESET_TP_KERNEL      = 3,
    gcvFLOP_RESET_TP_DATA_NUM
}
gceFLOP_RESET_TP_DATA;


static gctUINT32 flopResetInputs[] = {
        0x33, /* uint8 */
        0x3266, /* fp16 */
        0x33, /* int8 */
        1, /* uint16 */
        0x33, /* int16 */
        1, /* uint4 */
        1, /* int4 */
        0x3f80       /* bf16 */
    };


typedef struct{
    gctUINT32 ChipID;
    gctUINT32 ChipVersion;
    gctUINT32 ProductID;
    gctUINT32 EcoID;
    gctUINT32 customerID;
    gctUINT32 formalRelease;
    gctUINT8 InputDataType;
    gctUINT32 NNkerLen;
    gctUINT32 NNCmdLen;
    gctUINT32 NNCmdOffset;
    gctUINT32 TPCoreCount;
    gctUINT32 TPkerLen;
    gctUINT32 TPCmdLen;
    gctUINT32 TPCmdOffset[16];
    gctUINT32 NNIns[48];
    gctUINT32 NNKer[256];
    gctUINT32 NNCmd[192];
    gctUINT32 TPIns[256];
    gctUINT32 TPKer[512];
    gctUINT32 TPCmd[280];
}chipCmdData;

static chipCmdData chipcmd[]={
    {
        0x8000, /* ChipID */
        0x8002, /* ChipRevision */
        0x5080009, /* ProductID */
        0x6000000, /* EcoID */
        0x9f, /* CustomerID */
        0x0, /*formalRelease*/
        0, /*InputDataType*/
        0xC0, /*NNkerLen*/
        88, /*NNCmdLen*/
        15, /*NNCmdOffset*/
        3, /*TPCoreCount*/
        0x3C0, /*TPkerLen*/
        0x000000C8,
        {
            15, 29, 43
        },
        {
            0xA010004A, 0x001000C0, 0x54000000, 0x00080080,
            0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
            0x00012004, 0x00000000, 0x00000000, 0x00000800,
            0x00000880, 0x00000000, 0x00000800, 0x00000000,
            0x00020003, 0x01000002, 0x10000000, 0x03FFFFFF,
            0x00000000, 0x03FFFFFF, 0x00040000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x01030410, 0x00000100, 0x00000000, 0x00000000,
            0x00000000, 0x26540781, 0x00000000, 0x00000035,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xEC024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x0001FE00, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E4C, 0x00000040, 0x08010E54, 0x00000000,
            0x08010E27, 0x00000000, 0x08010428, 0xDFF47000,
            0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
            0x08010E03, 0x00000C23
        },
        {
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0002A1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
            0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010016, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA000281B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62140,
            0xC0000002, 0xDFF6E016, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010015, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA000281B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62280,
            0x80000002, 0xDFF6E02B, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010015, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
        },
        {
            0x01150410, 0x00000100, 0x00000000, 0x00000000,
            0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x01140410, 0x00000100, 0x00000000, 0x00000000,
            0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x01140410, 0x00000100, 0x00000000, 0x00000000,
            0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
        },
        {
            0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61001,
            0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
            0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
            0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61081, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000000, 0x08010E54, 0x00000000,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61100,
            0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
            0x08010E03, 0x00000C23
        }
    },
    {
        0x8000, /* ChipID */
        0x8003, /* ChipRevision */
        0x5080009, /* ProductID */
        0x4000000, /* EcoID */
        0xb5, /* CustomerID */
        0x0,
        0,
        0x000000C0, /* kerlen */
        0x00000058, /* cmdlen */
        15,
        2, /* tpcorecnt */
        0x00000280,
        0x00000090,
        {
            15, 29
        },
        {
            0xA010004A, 0x001000C0, 0x54000000, 0x00080080,
            0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
            0x00012004, 0x00000000, 0x00000000, 0x00000800,
            0x00000880, 0x00000000, 0x00000800, 0x00000000,
            0x00020003, 0x01000002, 0x10000000, 0x03FFFFFF,
            0x00000000, 0x03FFFFFF, 0x00040000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x01030410, 0x00000100, 0x00000000, 0x00000000,
            0x00000000, 0x26540781, 0x00000000, 0x00000035,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xEC024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x0001FE00, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E4C, 0x00000050, 0x08010E54, 0x00000000,
            0x08010E27, 0x00000000, 0x08010428, 0xDFF47000,
            0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
            0x08010E03, 0x00000C23
        },
        {
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0003E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
            0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010020, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0003E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62140,
            0x80000002, 0xDFF6E020, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010020, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
        },
        {
            0x011F0410, 0x00000100, 0x00000000, 0x00000000,
            0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x011F0410, 0x00000100, 0x00000000, 0x00000000,
            0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
        },
        {
            0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61001,
            0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
            0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
            0x08010E54, 0x00000000, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61080, 0x08010429, 0x00000000,
            0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
        },
    },
    {
        0x8000, /* ChipID */
        0x7004, /* ChipRevision */
        0x45080009, /* ProductID */
        0x0, /* EcoID */
        0x7d, /* CustomerID */
        0x0,
        0, /*InputDataType*/
        0x0C0,
        0x00000040,
        9,
        2, /*TPCoreCount*/
        0x00000280,
        0x00000068,
        {
            9, 19
        },
        {
            0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
            0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
            0x00012004, 0x00000000, 0x00000000, 0x00000800,
            0x00000880, 0x00000000, 0x00000800, 0x00000000,
            0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
            0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x00000040, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFF000100, 0x00000000, 0x00FFFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E4C, 0x00000000, 0x08010E27, 0x00000000,
            0x08010428, 0xDFF47000, 0x08010429, 0x00000000,
            0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
        },
        {
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0003E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
            0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010020, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0003E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62140,
            0x80000002, 0xDFF6E020, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010020, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
        },
        {
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61001, 0x08010E4F, 0x00000000,
            0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61080,
            0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
            0x08010E03, 0x00000C23
        },
    },
    {
        0x8000, /* ChipID */
        0x7004, /* ChipRevision */
        0x45080009, /* ProductID */
        0x1, /* EcoID */
        0x7d, /* CustomerID */
        0x0,
        0, /*InputDataType*/
        0x0C0,
        0x00000040,
        9,
        2, /*TPCoreCount*/
        0x00000280,
        0x00000068,
        {
            9, 19
        },
        {
            0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
            0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
            0x00012004, 0x00000000, 0x00000000, 0x00000800,
            0x00000880, 0x00000000, 0x00000800, 0x00000000,
            0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
            0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x00000040, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFF000100, 0x00000000, 0x00FFFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E4C, 0x00000000, 0x08010E27, 0x00000000,
            0x08010428, 0xDFF47000, 0x08010429, 0x00000000,
            0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
        },
        {
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0003E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
            0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010020, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0003E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62140,
            0x80000002, 0xDFF6E020, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010020, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
        },
        {
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61001, 0x08010E4F, 0x00000000,
            0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61080,
            0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
            0x08010E03, 0x00000C23
        }
    },
    {
        0x8000,
        0x7131,
        0x8000001,
        0x2000000,
        0x99,
        0x0,
        0, /*InputDataType*/
        0x00000080,
        0x00000058,
        15,
        8, /*TPkerLen*/
        0x00000800,
        0x000001E0,
        {15, 29, 43, 57, 71, 85, 99, 113},
        {
            0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
            0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
            0x00012004, 0x00000000, 0x00000000, 0x00000800,
            0x00000880, 0x00000000, 0x00000800, 0x00000000,
            0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
            0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x01020411, 0x00000100, 0x00000000, 0x00000000,
            0x00000000, 0x26540781, 0x00000000, 0x00000069,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x0073FFE0, 0xC0003800, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E4C, 0x00000010, 0x08010E54, 0x00000000,
            0x08010E27, 0x00000000, 0x08010428, 0xDFF47000,
            0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
            0x08010E03, 0x00000C23
        },
        {
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
            0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010008, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62100,
            0xC0000002, 0xDFF6E008, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010008, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62200,
            0xC0000002, 0xDFF6E010, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010008, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62300,
            0xC0000002, 0xDFF6E018, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010008, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62400,
            0xC0000002, 0xDFF6E020, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010008, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62500,
            0xC0000002, 0xDFF6E028, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010008, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62600,
            0xC0000002, 0xDFF6E030, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010008, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62700,
            0x80000002, 0xDFF6E038, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010008, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000

        },
        {
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000002, 0x08010E54, 0x00000008,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61001,
            0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
            0x08010E50, 0x00000000, 0x08010E53, 0x00000002,
            0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61081, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000002, 0x08010E54, 0x00000008,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61101,
            0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
            0x08010E50, 0x00000000, 0x08010E53, 0x00000002,
            0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61181, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000002, 0x08010E54, 0x00000008,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61201,
            0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
            0x08010E50, 0x00000000, 0x08010E53, 0x00000002,
            0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61281, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000002, 0x08010E54, 0x00000008,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61301,
            0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
            0x08010E50, 0x00000000, 0x08010E53, 0x00000002,
            0x08010E54, 0x00000000, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61380, 0x08010429, 0x00000000,
            0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
        }
    },
    {
        0x8000,
        0x7131,
        0x5000009,
        0x8000000,
        0xa1,
        0x0,
        0, /*InputDataType*/
        0x00000080,
        0x00000058,
        15,
        6, /*TPCoreCount*/
        0x00000600,
        0x00000170,
        {15, 29, 43, 57, 71, 85},
        {
            0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
            0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
            0x00012004, 0x00000000, 0x00000000, 0x00000800,
            0x00000A00, 0x00000000, 0x00000800, 0x00000000,
            0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
            0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x01020411, 0x00000100, 0x00000000, 0x00000000,
            0x00000000, 0x26540781, 0x00000000, 0x00000069,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x0073FFE0, 0xC0003800, 0x0000000F, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E4C, 0x00000010, 0x08010E54, 0x00000000,
            0x08010E27, 0x00000000, 0x08010428, 0xDFF47000,
            0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
            0x08010E03, 0x00000C23
        },
        {
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA000141B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
            0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x0001000B, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA000141B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62100,
            0xC0000002, 0xDFF6E00B, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x0001000B, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA000141B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62200,
            0xC0000002, 0xDFF6E016, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x0001000B, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA000141B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62300,
            0xC0000002, 0xDFF6E021, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x0001000B, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA000121B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62400,
            0xC0000002, 0xDFF6E02C, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x0001000A, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA000121B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62500,
            0x80000002, 0xDFF6E036, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x0001000A, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
        },
        {
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000

        },
        {
            0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61001,
            0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
            0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
            0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61081, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61101,
            0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
            0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
            0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61181, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61201,
            0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
            0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
            0x08010E54, 0x00000000, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61280, 0x08010429, 0x00000000,
            0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
        }
    },
    {
        0x8000, /* ChipID */
        0x7120, /* ChipRevision */
        0x45080009, /* ProductID */
        0x0, /* EcoID */
        0x88, /* CustomerID */
        0x0,
        0, /*InputDataType*/
        0x00000240,
        0x00000040,
        9,
        4, /*TPCoreCount*/
        0x00000400,
        0x000000B8,
        {9, 19, 29, 39},
        {
            0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
            0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
            0x00012004, 0x00000000, 0x00000000, 0x00000800,
            0x00000A00, 0x00000000, 0x00000800, 0x00000000,
            0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
            0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x00000040, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFF000100, 0x00000000, 0x00FFFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4F, 0x01000000, 0x08010E50, 0x01100000,
            0x08010E4C, 0x00000010, 0x08010E27, 0x00000000,
            0x08010428, 0xDFF47000, 0x08010429, 0x00000000,
            0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
        },
        {
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0001E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
            0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010010, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0001E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62100,
            0xC0000002, 0xDFF6E010, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010010, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0001E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62200,
            0xC0000002, 0xDFF6E020, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010010, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0001E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62300,
            0x80000002, 0xDFF6E030, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010010, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
        },
        {
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4F, 0x01000000, 0x08010E50, 0x01100000,
            0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61001, 0x08010E4F, 0x01000000,
            0x08010E50, 0x01100000, 0x08010E53, 0x00000000,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61081,
            0x08010E4F, 0x01000000, 0x08010E50, 0x01100000,
            0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61101, 0x08010E4F, 0x01000000,
            0x08010E50, 0x01100000, 0x08010E53, 0x00000000,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61180,
            0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
            0x08010E03, 0x00000C23
        }
    },
    {
        0x8000, /* ChipID */
        0x8002, /* ChipRevision */
        0x5080009, /* ProductID */
        0x6000000, /* EcoID */
        0xa0, /* CustomerID */
        0x0,
        0, /*InputDataType*/
        0x000000C0,
        0x00000058,
        15,
        3, /*TPCoreCount*/
        0x000003C0,
        0x000000C8,
        {15, 29, 43},
        {
            0xA010004A, 0x001000C0, 0x54000000, 0x00080080,
            0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
            0x00012004, 0x00000000, 0x00000000, 0x00000800,
            0x00000880, 0x00000000, 0x00000800, 0x00000000,
            0x00020003, 0x01000002, 0x10000000, 0x03FFFFFF,
            0x00000000, 0x03FFFFFF, 0x00040000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x01030410, 0x00000100, 0x00000000, 0x00000000,
            0x00000000, 0x26540781, 0x00000000, 0x00000035,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xEC024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x0001FE00, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E4C, 0x00000040, 0x08010E54, 0x00000000,
            0x08010E27, 0x00000000, 0x08010428, 0xDFF47000,
            0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
            0x08010E03, 0x00000C23
        },
        {
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0002A1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
            0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010016, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA000281B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62140,
            0xC0000002, 0xDFF6E016, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010015, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA000281B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62280,
            0x80000002, 0xDFF6E02B, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010015, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
        },
        {
            0x01150410, 0x00000100, 0x00000000, 0x00000000,
            0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x01140410, 0x00000100, 0x00000000, 0x00000000,
            0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x01140410, 0x00000100, 0x00000000, 0x00000000,
            0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00024938, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
        },
        {
            0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61001,
            0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
            0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
            0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61081, 0x08010E4E, 0x00400000,
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000000, 0x08010E54, 0x00000000,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61100,
            0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
            0x08010E03, 0x00000C23
        }
    },
    {
        0x8000, /* ChipID */
        0x7300, /* ChipRevision */
        0x5080008, /* ProductID */
        0x10000000, /* EcoID */
        0x86, /* CustomerID */
        0x0, /* gctUINT32 formalRelease; */
        0, /*InputDataType*/
        0x000000C0, /* NNkerLen */
        0x00000040, /* NNCmdLen */
        9, /* gctUINT32 NNCmdOffset */
        1, /*TPCoreCount*/
        0x00000240,
        0x00000040,
        {9},
        {
            0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
            0x02084001, 0x037FB600, 0xDFEFF000, 0xDFEFE000,
            0x00012004, 0x00000000, 0x00000000, 0x00000800,
            0x00000880, 0x00000000, 0x00000800, 0x00000000,
            0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
            0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x00000040, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFF000100, 0x00000000, 0x00FFFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4F, 0xF0800000, 0x08010E50, 0xF0980000,
            0x08010E4C, 0x00002010, 0x08010E27, 0x00000000,
            0x08010428, 0x100BB000, 0x08010429, 0x00000000,
            0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
        },
        {
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0007E1B, 0x00000000,
            0x00010001, 0x00010001, 0x1008D000, 0x1009A000,
            0x80000002, 0x1008E000, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010040, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
        },
        {
            0x00000042, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4F, 0xF0800000, 0x08010E50, 0xF0980000,
            0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
            0x0801042E, 0x1009B000, 0x08010429, 0x00000000,
            0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
        }
    },

    {
        0x8000, /* ChipID */
        0x7121, /* ChipRevision */
        0x508000b, /* ProductID */
        0x2000000, /* EcoID */
        0x98, /* CustomerID */
        0x0,
        0, /*InputDataType*/
        0x000000C0,
        0x00000040,
        9,
        2, /*TPCoreCount*/
        0x00000280,
        0x00000068,
        {9, 19},
        {
            0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
            0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
            0x00012004, 0x00000000, 0x00000000, 0x00000800,
            0x00000880, 0x00000000, 0x00000800, 0x00000000,
            0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
            0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x00000040, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFF000100, 0x00000000, 0x00FFFFFF, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E4C, 0x00000010, 0x08010E27, 0x00000000,
            0x08010428, 0xDFF47000, 0x08010429, 0x00000000,
            0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
        },
        {
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0003E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
            0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010020, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0xA0003E1B, 0x00000000,
            0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62140,
            0x80000002, 0xDFF6E020, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010020, 0x00000000,
            0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
        },
        {
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000021, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xFFFFFFF0, 0xFFFFFFFF ,0xFFFFFFFF, 0xFFFFFFFF,
            0xFFFFFFFF, 0xFFFFFFFF ,0xFFFFFFFF, 0xFFFFFFFF,
            0x0000000F, 0x00000000 ,0x00000000, 0x00000000,
            0x00000000, 0x00000000 ,0x00000000, 0x00000000
        },
        {
            0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
            0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
            0x0801042E, 0xDFF61001, 0x08010E4F, 0x00000000,
            0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
            0x08010E27, 0x00000000, 0x0801042E, 0xDFF61080,
            0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
            0x08010E03, 0x00000C23
        }
    },

    {
        0x8000,
        0x7005,
        0x15080003,
        0x0,
        0x83,
        0x0,
        1, /*InputDataType*/
        0x000000C0,
        0x00000030,
        5,
        1, /*TPCoreCount*/
        0x000002C0,
        0x00000030,
        {5},
        {
            0xA0100048, 0x00180095, 0x00000000, 0x00100040,
            0x04044001, 0x00402651, 0x10098900, 0x10098940,
            0x00022004, 0x00000000, 0x00000000, 0x00000800,
            0x00000880, 0x00000000, 0x00000800, 0x00000000,
            0x00030004, 0x00000002, 0x00000000, 0x03FFFFFF,
            0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x00000040, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x77000100, 0xB7248C3A, 0x66B2213E, 0x00B8D1B4,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E4C, 0x00002014, 0x08010E27, 0x00000000,
            0x08010428, 0x1008CB80, 0x08010429, 0x00000000,
            0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
        },
        {
            0x00000001, 0x00020001, 0x00000001, 0x00000001,
            0x00000000, 0x00000000, 0x80007E4B, 0x00000000,
            0x00010001, 0x00010001, 0x1008BF40, 0x1008C500,
            0x80240002, 0x1008BF80, 0x00000000, 0x00000000,
            0x00010001, 0x00000000, 0x00000000, 0x00010001,
            0x00000001, 0x00000000, 0x00010040, 0x00000000,
            0x0000000A, 0x00000000, 0x03FFFFFF, 0x00000000,
            0x03FFFFFF, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x00000063, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0xD8A394C0, 0xDB536192, 0x8683A0F3, 0x1F3231B3,
            0x9163B433, 0x713C0483, 0xADCA71B3, 0xB4BB996B,
            0xC4133813, 0x2F6B657B, 0xED63FA8B, 0x8893C44B,
            0xA6F3D663, 0xCF23293B, 0x08D3A0D3, 0x7443D1DB,
            0xC0CB5EFB, 0x9C43BEF3, 0x11731F5B, 0x6833D8D3,
            0x9A0BDFDB, 0x8692DC5B, 0x7F63D793, 0x654B583B,
            0xD0BBBFDB, 0xD19B9A23, 0xF71B9913, 0x9FDB84DB,
            0x7A7368FB, 0xF4FB8733, 0x6EEBB1EB, 0x467409BB,
            0x00000003, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x9CDBAE40, 0xA023DF13, 0xED6B86CB, 0x02141263,
            0x5E840804, 0x255BF753, 0x681B233B, 0x213363BB,
            0xBFCB1F6B, 0xCD6B70CB, 0x4E93CD6B, 0xC35B18F3,
            0xF683E31B, 0x8AA39133, 0x21339D42, 0x0073DFA2,
            0x1C1C00B4, 0xFB436CE3, 0xC9DB2223, 0x7D13B6BB,
            0xB1DAEEBB, 0xEEB3EBB3, 0xAB6AE26B, 0x77C3D89B,
            0x42137D6B, 0x16CADFAB, 0x76B3F09C, 0x4EA384B3,
            0x82D32C33, 0x36CBC21B, 0x028BA1B3, 0x8BFBEC1C,
            0x00000003, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000,
            0x00000000, 0x00000000, 0x00000000, 0x00000000
        },
        {
            0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
            0x0801042E, 0x1008C800, 0x08010429, 0x00000000,
            0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
        }
    },

    {
            0x8000, /* ChipID */
            0x7120, /* ChipRevision */
            0x508000b, /* ProductID */
            0x6000000, /* EcoID */
            0x92, /* CustomerID */
            0x0,
            0, /*InputDataType*/
            0x000001C0,
            0x00000048,
            11,
            6, /*TPCoreCount*/
            0x00000600,
            0x00000138,
            {11, 23, 35, 47, 59, 71},
            {
                0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
                0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
                0x00012004, 0x00000000, 0x00000000, 0x00000800,
                0x00000980, 0x00000000, 0x00000800, 0x00000000,
                0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
                0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x00000040, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFF000100, 0x00000000, 0x00FFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4F, 0x01000000, 0x08010E50, 0x01080000,
                0x08010E4C, 0x00000000, 0x08010E54, 0x00000000,
                0x08010E27, 0x00000000, 0x08010428, 0xDFF47000,
                0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                0x08010E03, 0x00000C23
            },
            {
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000141B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
                0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000B, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000141B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62100,
                0xC0000002, 0xDFF6E00B, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000B, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000141B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62200,
                0xC0000002, 0xDFF6E016, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000B, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000141B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62300,
                0xC0000002, 0xDFF6E021, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000B, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000121B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62400,
                0xC0000002, 0xDFF6E02C, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000A, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000121B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62500,
                0x80000002, 0xDFF6E036, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000A, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
            },
            {
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4F, 0x01000000, 0x08010E50, 0x01080000,
                0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61001,
                0x08010E4F, 0x01000000, 0x08010E50, 0x01080000,
                0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61081,
                0x08010E4F, 0x01000000, 0x08010E50, 0x01080000,
                0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61101,
                0x08010E4F, 0x01000000, 0x08010E50, 0x01080000,
                0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61181,
                0x08010E4F, 0x01000000, 0x08010E50, 0x01080000,
                0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61201,
                0x08010E4F, 0x01000000, 0x08010E50, 0x01080000,
                0x08010E53, 0x00000000, 0x08010E54, 0x00000000,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61280,
                0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                0x08010E03, 0x00000C23
            }
    },

    {
            0x8000, /* ChipID */
            0x6205, /* ChipRevision */
            0x80003, /* ProductID */
            0x0, /* EcoID */
            0x15, /* CustomerID */
            0x0,
            0, /*InputDataType*/
            0x00000080,
            0x00000068,
            15,
            8, /*TPCoreCount*/
            0x00000800,
            0x000001B0,
            {13, 25, 37, 49, 61, 73, 85, 97},
            {
                0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
                0x02084001, 0x037FD1C0, 0xDFF6E000, 0xDFF6D000,
                0x00012004, 0x00000000, 0x00000000, 0x00000800,
                0x00000880, 0x00000000, 0x00000800, 0x00000000,
                0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
                0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x01020411, 0x00000100, 0x00000000, 0x00000000,
                0x00000000, 0x26540781, 0x00000000, 0x00000069,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x0073FFE0, 0xC0003800, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E4C, 0x00000010, 0x08010E54, 0x00000000,
                0x08010E27, 0x00000000, 0x08010428, 0xDFF46000,
                0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                0x08010E03, 0x00000C23, 0x08010594, 0x00000001,
                0x08010E03, 0x00000C23
            },
            {
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6E000, 0xDFF61000,
                0xC0000002, 0xDFF6D000, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6E000, 0xDFF61100,
                0xC0000002, 0xDFF6D008, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6E000, 0xDFF61200,
                0xC0000002, 0xDFF6D010, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6E000, 0xDFF61300,
                0xC0000002, 0xDFF6D018, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6E000, 0xDFF61400,
                0xC0000002, 0xDFF6D020, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6E000, 0xDFF61500,
                0xC0000002, 0xDFF6D028, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6E000, 0xDFF61600,
                0xC0000002, 0xDFF6D030, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6E000, 0xDFF61700,
                0x80000002, 0xDFF6D038, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
            },
            {
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0000000F, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000002, 0x08010E27, 0x00000000,
                0x0801042E, 0x738A1001, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000002, 0x08010E27, 0x00000000,
                0x0801042E, 0x738A1081, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000002, 0x08010E27, 0x00000000,
                0x0801042E, 0x738A1101, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000002, 0x08010E27, 0x00000000,
                0x0801042E, 0x738A1181, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000002, 0x08010E27, 0x00000000,
                0x0801042E, 0x738A1201, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000002, 0x08010E27, 0x00000000,
                0x0801042E, 0x738A1281, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000002, 0x08010E27, 0x00000000,
                0x0801042E, 0x738A1301, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000002, 0x08010E27, 0x00000000,
                0x0801042E, 0x738A1380, 0x08010429, 0x00000000,
                0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23,
                0x08010594, 0x00000001, 0x08010E03, 0x00000C23
            }
    },

    {
            0x8000, /* ChipID */
            0x8001, /* ChipRevision */
            0x5080009, /* ProductID */
            0x18000000, /* EcoID */
            0xa9, /* CustomerID */
            0x0,
            0, /*InputDataType*/
            0x00000100,
            0x00000058,
            15,
            8, /*TPCoreCount*/
            0x00000800,
            0x000001E0,
            {15, 29, 43, 57, 71, 85, 99, 113},
            {
                0xA010004A, 0x001000C0, 0x54000000, 0x00080080,
                0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
                0x00012004, 0x00000000, 0x00000000, 0x00000800,
                0x00000880, 0x00000000, 0x00000800, 0x00000000,
                0x00020003, 0x01000002, 0x10000000, 0x03FFFFFF,
                0x00000000, 0x03FFFFFF, 0x00040000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x01030410, 0x00000100, 0x00000000, 0x00000000,
                0x00000000, 0x26540781, 0x00000000, 0x00000035,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xEC024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x0001FE00, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E4C, 0x00000040, 0x08010E54, 0x00000000,
                0x08010E27, 0x00000000, 0x08010428, 0xDFF47000,
                0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                0x08010E03, 0x00000C23
            },
            {
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
                0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62100,
                0xC0000002, 0xDFF6E008, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62200,
                0xC0000002, 0xDFF6E010, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62300,
                0xC0000002, 0xDFF6E018, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62400,
                0xC0000002, 0xDFF6E020, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62500,
                0xC0000002, 0xDFF6E028, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62600,
                0xC0000002, 0xDFF6E030, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62700,
                0x80000002, 0xDFF6E038, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010008, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
            },
            {
                0x01070410, 0x00000100, 0x00000000, 0x00000000,
                0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x01070410, 0x00000100, 0x00000000, 0x00000000,
                0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x01070410, 0x00000100, 0x00000000, 0x00000000,
                0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x01070410, 0x00000100, 0x00000000, 0x00000000,
                0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x01070410, 0x00000100, 0x00000000, 0x00000000,
                0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x01070410, 0x00000100, 0x00000000, 0x00000000,
                0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x01070410, 0x00000100, 0x00000000, 0x00000000,
                0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x01070410, 0x00000100, 0x00000000, 0x00000000,
                0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00024938, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61001,
                0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
                0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
                0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
                0x0801042E, 0xDFF61081, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61101,
                0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
                0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
                0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
                0x0801042E, 0xDFF61181, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61201,
                0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
                0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
                0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
                0x0801042E, 0xDFF61281, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61301,
                0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
                0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
                0x08010E54, 0x00000000, 0x08010E27, 0x00000000,
                0x0801042E, 0xDFF61380, 0x08010429, 0x00000000,
                0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
            }
    },

    {
            0x8000, /* ChipID */
            0x7120, /* ChipRevision */
            0x15080009, /* ProductID */
            0x0, /* EcoID */
            0x80, /* CustomerID */
            0x0,
            0, /*InputDataType*/
            0x000000C0,
            0x00000040,
            9,
            2, /*TPCoreCount*/
            0x00000280,
            0x00000068,
            {9, 19},
            {
                0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
                0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
                0x00012004, 0x00000000, 0x00000000, 0x00000800,
                0x00000880, 0x00000000, 0x00000800, 0x00000000,
                0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
                0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x00000040, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFF000100, 0x00000000, 0x00FFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E4C, 0x00000000, 0x08010E27, 0x00000000,
                0x08010428, 0xDFF47000, 0x08010429, 0x00000000,
                0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
            },
            {
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0003E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
                0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010020, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0003E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62140,
                0x80000002, 0xDFF6E020, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010020, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
            },
            {
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
                0x0801042E, 0xDFF61001, 0x08010E4F, 0x00000000,
                0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61080,
                0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                0x08010E03, 0x00000C23
            }
    },
    {
            0x8000, /* ChipID */
            0x7110, /* ChipRevision */
            0x25080009, /* ProductID */
            0x0, /* EcoID */
            0x7f, /* CustomerID */
            0x0,
            0, /*InputDataType*/
            0x000001C0,
            0x00000040,
            9,
            6, /*TPCoreCount*/
            0x00000600,
            0x00000108,
            {9, 19, 29, 39, 49, 59 },
            {
                0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
                0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
                0x00012004, 0x00000000, 0x00000000, 0x00000800,
                0x00000980, 0x00000000, 0x00000800, 0x00000000,
                0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
                0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x00000040, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFF000100, 0x00000000, 0x00FFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4F, 0x01000000, 0x08010E50, 0x01080000,
                0x08010E4C, 0x00000010, 0x08010E27, 0x00000000,
                0x08010428, 0xDFF47000, 0x08010429, 0x00000000,
                0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
            },
            {
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000141B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
                0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000B, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000141B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62100,
                0xC0000002, 0xDFF6E00B, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000B, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000141B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62200,
                0xC0000002, 0xDFF6E016, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000B, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000141B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62300,
                0xC0000002, 0xDFF6E021, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000B, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000121B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62400,
                0xC0000002, 0xDFF6E02C, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000A, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000121B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62500,
                0x80000002, 0xDFF6E036, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000A, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
            },
            {
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4F, 0x01000000, 0x08010E50, 0x01080000,
                0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
                0x0801042E, 0xDFF61001, 0x08010E4F, 0x01000000,
                0x08010E50, 0x01080000, 0x08010E53, 0x00000000,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61081,
                0x08010E4F, 0x01000000, 0x08010E50, 0x01080000,
                0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
                0x0801042E, 0xDFF61101, 0x08010E4F, 0x01000000,
                0x08010E50, 0x01080000, 0x08010E53, 0x00000000,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61181,
                0x08010E4F, 0x01000000, 0x08010E50, 0x01080000,
                0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
                0x0801042E, 0xDFF61201, 0x08010E4F, 0x01000000,
                0x08010E50, 0x01080000, 0x08010E53, 0x00000000,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61280,
                0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                0x08010E03, 0x00000C23
            }
    },

    {
            0x8000, /* ChipID */
            0x7121, /* ChipRevision */
            0x5000009, /* ProductID */
            0x2000000, /* EcoID */
            0x97, /* CustomerID */
            0x0,
            0, /*InputDataType*/
            0x000000C0,
            0x00000040,
            9,
            2, /*TPCoreCount*/
            0x00000280,
            0x00000068,
            {9, 19},
            {
                0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
                0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
                0x00012004, 0x00000000, 0x00000000, 0x00000800,
                0x00000880, 0x00000000, 0x00000800, 0x00000000,
                0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
                0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x00000040, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFF000100, 0x00000000, 0x00FFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E4C, 0x00000010, 0x08010E27, 0x00000000,
                0x08010428, 0xDFF47000, 0x08010429, 0x00000000,
                0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
            },
            {
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0003E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
                0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010020, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0003E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62140,
                0x80000002, 0xDFF6E020, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010020, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
            },
            {
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
                0x0801042E, 0xDFF61001, 0x08010E4F, 0x00000000,
                0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61080,
                0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                0x08010E03, 0x00000C23
            }
    },
    {
           0x8000, /* ChipID */
            0x7100, /* ChipRevision */
            0x45080001, /* ProductID */
            0x0, /* EcoID */
            0x82, /* CustomerID */
            0x0,
            0, /*InputDataType*/
            0x000002C0,
            0x00000040,
            9,
            6, /*TPCoreCount*/
            0x600,
            0x00000108,
            {9, 19, 29, 39, 49, 59},
            {
                0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
                0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
                0x00012004, 0x00000000, 0x00000000, 0x00000800,
                0x00000A80, 0x00000000, 0x00000800, 0x00000000,
                0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
                0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x00000040, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFF000100, 0x00000000, 0x00FFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4F, 0x01000000, 0x08010E50, 0x011F0000,
                0x08010E4C, 0x00000010, 0x08010E27, 0x00000000,
                0x08010428, 0xDFF47000, 0x08010429, 0x00000000,
                0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
            },
            {
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000141B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
                0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000B, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000141B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62100,
                0xC0000002, 0xDFF6E00B, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000B, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000141B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62200,
                0xC0000002, 0xDFF6E016, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000B, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000141B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62300,
                0xC0000002, 0xDFF6E021, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000B, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000121B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62400,
                0xC0000002, 0xDFF6E02C, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000A, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA000121B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62500,
                0x80000002, 0xDFF6E036, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x0001000A, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
            },
            {
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x0FFFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0x000FFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
            },
            {
                0x08010E4F, 0x01000000, 0x08010E50, 0x011F0000,
                0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
                0x0801042E, 0xDFF61001, 0x08010E4F, 0x01000000,
                0x08010E50, 0x011F0000, 0x08010E53, 0x00000000,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61081,
                0x08010E4F, 0x01000000, 0x08010E50, 0x011F0000,
                0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
                0x0801042E, 0xDFF61101, 0x08010E4F, 0x01000000,
                0x08010E50, 0x011F0000, 0x08010E53, 0x00000000,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61181,
                0x08010E4F, 0x01000000, 0x08010E50, 0x011F0000,
                0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
                0x0801042E, 0xDFF61201, 0x08010E4F, 0x01000000,
                0x08010E50, 0x011F0000, 0x08010E53, 0x00000000,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61280,
                0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                0x08010E03, 0x00000C23
            }
    },
    {
            0x8000, /* ChipID */
            0x7131, /* ChipRevision */
            0x25080009, /* ProductID */
            0x0, /* EcoID */
            0x84, /* CustomerID */
            0x0,
            0, /*InputDataType*/
            0x00000140,
            0x00000058,
            15,
            4, /*TPCoreCount*/
            0x00000400,
            0x00000100,
            {15, 29, 43, 57},
            {
                0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
                0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
                0x00012004, 0x00000000, 0x00000000, 0x00000800,
                0x00000900, 0x00000000, 0x00000800, 0x00000000,
                0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
                0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x00000040, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFF000100, 0x00000000, 0x00FFFFFF, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E4C, 0x00000010, 0x08010E54, 0x00000000,
                0x08010E27, 0x00000000, 0x08010428, 0xDFF47000,
                0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                0x08010E03, 0x00000C23
            },
            {
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0001E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
                0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010010, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0001E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62100,
                0xC0000002, 0xDFF6E010, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010010, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0001E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62200,
                0xC0000002, 0xDFF6E020, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010010, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                0x00000001, 0x00020001, 0x00000001, 0x00000001,
                0x00000000, 0x00000000, 0xA0001E1B, 0x00000000,
                0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62300,
                0x80000002, 0xDFF6E030, 0x00000000, 0x00000000,
                0x00010001, 0x00000000, 0x00000000, 0x00010001,
                0x00000001, 0x00000000, 0x00010010, 0x00000000,
                0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
            },
            {
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000021, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000,
                0x00000000, 0x00000000, 0x00000000, 0x00000000
            },
            {
                0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61001,
                0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
                0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
                0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
                0x0801042E, 0xDFF61081, 0x08010E4E, 0x00400000,
                0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                0x08010E27, 0x00000000, 0x0801042E, 0xDFF61101,
                0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
                0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
                0x08010E54, 0x00000000, 0x08010E27, 0x00000000,
                0x0801042E, 0xDFF61180, 0x08010429, 0x00000000,
                0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
            }
    },
    {
                0x8000, /* ChipID */
                0x7131, /* ChipRevision */
                0x5000009, /* ProductID */
                0x2000000, /* EcoID */
                0x9, /* CustomerID */
                0,
                0, /*InputDataType*/
                0x00000080,
                0x00000058,
                15,
                1, /*TPCoreCount*/
                0x00000240,
                0x00000058,
                {15},
                {
                    0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
                    0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
                    0x00012004, 0x00000000, 0x00000000, 0x00000800,
                    0x00000880, 0x00000000, 0x00000800, 0x00000000,
                    0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
                    0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x01020411, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26540781, 0x00000000, 0x00000069,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x0073FFE0, 0xC0003800, 0x0000000F, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                    0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                    0x08010E4C, 0x00000010, 0x08010E54, 0x00000000,
                    0x08010E27, 0x00000000, 0x08010428, 0xDFF47000,
                    0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                    0x08010E03, 0x00000C23
                },
                {
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA0007E1B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
                    0x80000002, 0xDFF6E000, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010040, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
                },
                {
                    0x00000042, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                    0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                    0x08010E53, 0x00000000, 0x08010E54, 0x00000000,
                    0x08010E27, 0x00000000, 0x0801042E, 0xDFF61000,
                    0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                    0x08010E03, 0x00000C23
                }
    },
    {
                0x7000, /* ChipID */
                0x6210, /* ChipRevision */
                0x70002, /* ProductID */
                0x0, /* EcoID */
                0x9, /* CustomerID */
                0,
                0, /*InputDataType*/
                0x00000080,
                0x00000058,
                15,
                1, /*TPCoreCount*/
                0x00000240,
                0x00000058,
                {15},
                {
                    0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
                    0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
                    0x00012004, 0x00000000, 0x00000000, 0x00000800,
                    0x00000880, 0x00000000, 0x00000800, 0x00000000,
                    0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
                    0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x01020411, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26540781, 0x00000000, 0x00000069,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x0073FFE0, 0xC0003800, 0x0000000F, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                    0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                    0x08010E4C, 0x00000010, 0x08010E54, 0x00000000,
                    0x08010E27, 0x00000000, 0x08010428, 0xDFF47000,
                    0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                    0x08010E03, 0x00000C23
                },
                {
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA0007E1B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
                    0x80000002, 0xDFF6E000, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010040, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
                },
                {
                    0x00000042, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                    0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                    0x08010E53, 0x00000000, 0x08010E54, 0x00000000,
                    0x08010E27, 0x00000000, 0x0801042E, 0xDFF61000,
                    0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                    0x08010E03, 0x00000C23
                }
    },
    {
                0x8000, /* ChipID */
                0x8003, /* ChipRevision */
                0x5080009, /* ProductID */
                0x4000000, /* EcoID */
                0xa5, /* CustomerID */
                0,
                0, /*InputDataType*/
                0x000000C0,
                0x00000058,
                15,
                2, /*TPCoreCount*/
                0x00000280,
                0x00000090,
                {15, 29},
                {
                    0xA010004A, 0x001000C0, 0x54000000, 0x00080080,
                    0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
                    0x00012004, 0x00000000, 0x00000000, 0x00000800,
                    0x00000880, 0x00000000, 0x00000800, 0x00000000,
                    0x00020003, 0x01000002, 0x10000000, 0x03FFFFFF,
                    0x00000000, 0x03FFFFFF, 0x00040000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x01030410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26540781, 0x00000000, 0x00000035,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xEC024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x0001FE00, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                    0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                    0x08010E4C, 0x00000040, 0x08010E54, 0x00000000,
                    0x08010E27, 0x00000000, 0x08010428, 0xDFF47000,
                    0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                    0x08010E03, 0x00000C23
                },
                {
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA0003E1B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
                    0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010020, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA0003E1B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62140,
                    0x80000002, 0xDFF6E020, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010020, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
                },
                {
                    0x011F0410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x011F0410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                    0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                    0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                    0x08010E27, 0x00000000, 0x0801042E, 0xDFF61001,
                    0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
                    0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
                    0x08010E54, 0x00000000, 0x08010E27, 0x00000000,
                    0x0801042E, 0xDFF61080, 0x08010429, 0x00000000,
                    0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
                }
    },
    {
                0x8000, /* ChipID */
                0x8000, /* ChipRevision */
                0x5080009, /* ProductID */
                0x16000000, /* EcoID */
                0xa3, /* CustomerID */
                0,
                0, /*InputDataType*/
                0x00000100,
                0x00000058,
                15,
                8, /*TPCoreCount*/
                0x00000800,
                0x000001E0,
                {15, 29, 43, 57, 71, 85, 99, 113},
                {
                    0xA010004A, 0x001000C0, 0x54000000, 0x00080080,
                    0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
                    0x00012004, 0x00000000, 0x00000000, 0x00000800,
                    0x00000880, 0x00000000, 0x00000800, 0x00000000,
                    0x00020003, 0x01000002, 0x10000000, 0x03FFFFFF,
                    0x00000000, 0x03FFFFFF, 0x00040000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x01030410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26540781, 0x00000000, 0x00000035,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xEC024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x0001FE00, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                    0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                    0x08010E4C, 0x00000010, 0x08010E54, 0x00000000,
                    0x08010E27, 0x00000000, 0x08010428, 0xDFF47000,
                    0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                    0x08010E03, 0x00000C23
                },
                {
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
                    0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010008, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62100,
                    0xC0000002, 0xDFF6E008, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010008, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62200,
                    0xC0000002, 0xDFF6E010, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010008, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62300,
                    0xC0000002, 0xDFF6E018, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010008, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62400,
                    0xC0000002, 0xDFF6E020, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010008, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62500,
                    0xC0000002, 0xDFF6E028, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010008, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62600,
                    0xC0000002, 0xDFF6E030, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010008, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA0000E1B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62700,
                    0x80000002, 0xDFF6E038, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010008, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
                },
                {
                    0x01070410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x01070410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x01070410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x01070410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x01070410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x01070410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x01070410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x01070410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                    0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                    0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                    0x08010E27, 0x00000000, 0x0801042E, 0xDFF61001,
                    0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
                    0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
                    0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
                    0x0801042E, 0xDFF61081, 0x08010E4E, 0x00400000,
                    0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                    0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                    0x08010E27, 0x00000000, 0x0801042E, 0xDFF61101,
                    0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
                    0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
                    0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
                    0x0801042E, 0xDFF61181, 0x08010E4E, 0x00400000,
                    0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                    0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                    0x08010E27, 0x00000000, 0x0801042E, 0xDFF61201,
                    0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
                    0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
                    0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
                    0x0801042E, 0xDFF61281, 0x08010E4E, 0x00400000,
                    0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                    0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                    0x08010E27, 0x00000000, 0x0801042E, 0xDFF61301,
                    0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
                    0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
                    0x08010E54, 0x00000000, 0x08010E27, 0x00000000,
                    0x0801042E, 0xDFF61380, 0x08010429, 0x00000000,
                    0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
                }
    },
    {
                0x8000, /* ChipID */
                0x7003, /* ChipRevision */
                0x15080001, /* ProductID */
                0x0, /* EcoID */
                0x23, /* CustomerID */
                0,
                1, /*InputDataType*/
                0x000000C0,
                0x00000030,
                5,
                1, /*TPCoreCount*/
                0x000002C0,
                0x00000030,
                {5},
                {
                    0xA0100048, 0x00180095, 0x00000000, 0x00100040,
                    0x04044001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
                    0x00022004, 0x00000000, 0x00000000, 0x00000800,
                    0x00000880, 0x00000000, 0x00000800, 0x00000000,
                    0x00030004, 0x00000002, 0x00000000, 0x03FFFFFF,
                    0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x00000040, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x77000100, 0xB7248C3A, 0x66B2213E, 0x00B8D1B4,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010E4C, 0x0000001C, 0x08010E27, 0x00000000,
                    0x08010428, 0xDFF47000, 0x08010429, 0x00000000,
                    0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
                },
                {
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0x80007E4B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
                    0x80240002, 0xDFF6E000, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010040, 0x00000000,
                    0x0000000A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x00000063, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xD8A394C0, 0xDB536192, 0x8683A0F3, 0x1F3231B3,
                    0x9163B433, 0x713C0483, 0xADCA71B3, 0xB4BB996B,
                    0xC4133813, 0x2F6B657B, 0xED63FA8B, 0x8893C44B,
                    0xA6F3D663, 0xCF23293B, 0x08D3A0D3, 0x7443D1DB,
                    0xC0CB5EFB, 0x9C43BEF3, 0x11731F5B, 0x6833D8D3,
                    0x9A0BDFDB, 0x8692DC5B, 0x7F63D793, 0x654B583B,
                    0xD0BBBFDB, 0xD19B9A23, 0xF71B9913, 0x9FDB84DB,
                    0x7A7368FB, 0xF4FB8733, 0x6EEBB1EB, 0x467409BB,
                    0x00000003, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x9CDBAE40, 0xA023DF13, 0xED6B86CB, 0x02141263,
                    0x5E840804, 0x255BF753, 0x681B233B, 0x213363BB,
                    0xBFCB1F6B, 0xCD6B70CB, 0x4E93CD6B, 0xC35B18F3,
                    0xF683E31B, 0x8AA39133, 0x21339D42, 0x0073DFA2,
                    0x1C1C00B4, 0xFB436CE3, 0xC9DB2223, 0x7D13B6BB,
                    0xB1DAEEBB, 0xEEB3EBB3, 0xAB6AE26B, 0x77C3D89B,
                    0x42137D6B, 0x16CADFAB, 0x76B3F09C, 0x4EA384B3,
                    0x82D32C33, 0x36CBC21B, 0x028BA1B3, 0x8BFBEC1C,
                    0x00000003, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
                    0x0801042E, 0xDFF61000, 0x08010429, 0x00000000,
                    0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
                }
    },
    {
                0x8000, /* ChipID */
                0x7005, /* ChipRevision */
                0x5000009, /* ProductID */
                0x2000000, /* EcoID */
                0x96, /* CustomerID */
                0,
                2, /*InputDataType*/
                0x000000C0,
                0x00000030,
                5,
                1, /*TPCoreCount*/
                0x00000240,
                0x00000030,
                {5},
                {
                    0xA0100048, 0x001800AA, 0x40000000, 0x00100040,
                    0x04044001, 0x00091F40, 0x020004C0, 0x0247C500,
                    0x00022004, 0x00000000, 0x00000000, 0x00000800,
                    0x00000880, 0x00000000, 0x00000800, 0x00000000,
                    0x00030002, 0x00000001, 0x00000000, 0x03FFFFFF,
                    0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x00000040, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x23000100, 0x0000272A, 0x0051F85F, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010E4C, 0x0000001C, 0x08010E27, 0x00000000,
                    0x08010428, 0x0247D100, 0x08010429, 0x00000000,
                    0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
                },
                {
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA0007E9B, 0x00000000,
                    0x00010001, 0x00010001, 0x020004C0, 0x0247C9C0,
                    0x80480002, 0x0247C500, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010040, 0x00000000,
                    0x00001C0A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x00000042, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xCF4064C0, 0x5122B0A0, 0xF04031BE, 0x307EB261,
                    0x3F826E5F, 0x9DD141CF, 0x50304FCF, 0x1D5FE010,
                    0x8CEE7D90, 0xCFCE4F1D, 0x30B22E1E, 0x929F702E,
                    0xBD912FF0, 0x0D322DA0, 0x8340C38F, 0x1EEE8EB0,
                    0x00000003, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x607FA320, 0x5E4D12CE, 0x70422EB0, 0x509E4160,
                    0x8F3F804F, 0x9EBF7BA1, 0x3201CE6F, 0x4E900D1F,
                    0x41B1C56F, 0xC29E9D6D, 0xE0FF9F6E, 0x91CD6FED,
                    0x6DC32D4D, 0x329E0EC4, 0xB2BDD021, 0x61EF8B00,
                    0x00000001, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010E53, 0x00000000, 0x08010E27, 0x00000000,
                    0x0801042E, 0x0247CC40, 0x08010429, 0x00000000,
                    0x08010E03, 0x00000C23, 0x08010E03, 0x00000C23
                }
    },
    {
                0x8000, /* ChipID */
                0x7200, /* ChipRevision */
                0x4508000a, /* ProductID */
                0x0, /* EcoID */
                0x85, /* CustomerID */
                0,
                0, /*InputDataType*/
                0x000000C0,
                0x00000038,
                11,
                4, /*TPCoreCount*/
                0x00000400,
                0x000000E0,
                {11, 25, 39, 53},
                {
                    0xA0100048, 0x001000C0, 0xC8000000, 0x00080080,
                    0x02084001, 0x037FD340, 0xDFF74000, 0xDFF73000,
                    0x00012004, 0x00000000, 0x00000000, 0x00000800,
                    0x00000900, 0x00000000, 0x00000800, 0x00000000,
                    0x00020003, 0x01000002, 0x00000000, 0x03FFFFFF,
                    0x00000000, 0x03FFFFFF, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x01020411, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26540781, 0x00000000, 0x00000069,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x0073FFE0, 0xC0003800, 0x0000000F, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010e4e, 0x00400000, 0x08010e4f, 0x00000000,
                    0x08010e50, 0x00000000, 0x08010e4c, 0x00002010,
                    0x08010e54, 0x00000000, 0x08010e43, 0x037fd300,
                    0xb0010000, 0x18000000
                },
                {
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xa0001e1b, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF74000, 0xDFF67000,
                    0xc0000002, 0xDFF73000, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010010, 0x00000000,
                    0x0000240a, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,

                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xa0001e1b, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF74000, 0xDFF67100,
                    0xc0000002, 0xDFF73010, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010010, 0x00000000,
                    0x0000240a, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,

                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xa0001e1b, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF74000, 0xDFF67200,
                    0xc0000002, 0xDFF73020, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010010, 0x00000000,
                    0x0000240a, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,

                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xa0001e1b, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF74000, 0xDFF67300,
                    0x80000002, 0xDFF73030, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010010, 0x00000000,
                    0x0000240a, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
                },
                {
                    0x00000021, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000021, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000021, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000021, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xFFFFFFF0, 0xFFFFFFFF, 0xFFFFFFFF, 0xFFFFFFFF,
                    0x0000000F, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                     0x08010e4e, 0x00400000, 0x08010e4f, 0x00000000,
                     0x08010e50, 0x00000000, 0x08010e53, 0x00000000,
                     0x08010e54, 0x00000008, 0x08010e4d, 0x037fd980,
                     0xb0010000, 0x18000000, 0x08010e4e, 0x00400000,
                     0x08010e4f, 0x00000000, 0x08010e50, 0x00000000,
                     0x08010e53, 0x00000000, 0x08010e54, 0x00000008,
                     0x08010e4d, 0x037fd982, 0xb0010000, 0x18000000,
                     0x08010e4e, 0x00400000, 0x08010e4f, 0x00000000,
                     0x08010e50, 0x00000000, 0x08010e53, 0x00000000,
                     0x08010e54, 0x00000008, 0x08010e4d, 0x037fd984,
                     0xb0010000, 0x18000000, 0x08010e4e, 0x00400000,
                     0x08010e4f, 0x00000000, 0x08010e50, 0x00000000,
                     0x08010e53, 0x00000000, 0x08010e54, 0x00000000,
                     0x08010e4d, 0x037fd986, 0xb0010000, 0x18000000
                }
    },
    {
                0x8000, /* ChipID */
                0x8003, /* ChipRevision */
                0x5080009, /* ProductID */
                0x6000000, /* EcoID */
                0xb3, /* CustomerID */
                0,
                0, /*InputDataType*/
                0x000000C0,
                0x00000058,
                15,
                3, /*TPCoreCount*/
                0x000003C0,
                0x000000C8,
                {15, 29, 43},
                {
                    0xA010004A, 0x001000C0, 0x54000000, 0x00080080,
                    0x02084001, 0x037FD200, 0xDFF6F000, 0xDFF6E000,
                    0x00012004, 0x00000000, 0x00000000, 0x00000800,
                    0x00000880, 0x00000000, 0x00000800, 0x00000000,
                    0x00020003, 0x01000002, 0x10000000, 0x03FFFFFF,
                    0x00000000, 0x03FFFFFF, 0x00040000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x01030410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26540781, 0x00000000, 0x00000035,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0xEC024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x0001FE00, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                    0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                    0x08010E4C, 0x00000040, 0x08010E54, 0x00000000,
                    0x08010E27, 0x00000000, 0x08010428, 0xDFF47000,
                    0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                    0x08010E03, 0x00000C23
                },
                {
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA0002A1B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62000,
                    0xC0000002, 0xDFF6E000, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010016, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA000281B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62140,
                    0xC0000002, 0xDFF6E016, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010015, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000,
                    0x00000001, 0x00020001, 0x00000001, 0x00000001,
                    0x00000000, 0x00000000, 0xA000281B, 0x00000000,
                    0x00010001, 0x00010001, 0xDFF6F000, 0xDFF62280,
                    0x80000002, 0xDFF6E02B, 0x00000000, 0x00000000,
                    0x00010001, 0x00000000, 0x00000000, 0x00010001,
                    0x00000001, 0x00000000, 0x00010015, 0x00000000,
                    0x0000240A, 0x00000000, 0x03FFFFFF, 0x00000000,
                    0x03FFFFFF, 0x00000000, 0x00008100, 0x00000000
                },
                {
                    0x01150410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x01140410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x01140410, 0x00000100, 0x00000000, 0x00000000,
                    0x00000000, 0x26543780, 0x000000FF, 0x0006801A,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00024938, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000,
                    0x00000000, 0x00000000, 0x00000000, 0x00000000
                },
                {
                    0x08010E4E, 0x00400000, 0x08010E4E, 0x00400000,
                    0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                    0x08010E53, 0x00000000, 0x08010E54, 0x00000008,
                    0x08010E27, 0x00000000, 0x0801042E, 0xDFF61001,
                    0x08010E4E, 0x00400000, 0x08010E4F, 0x00000000,
                    0x08010E50, 0x00000000, 0x08010E53, 0x00000000,
                    0x08010E54, 0x00000008, 0x08010E27, 0x00000000,
                    0x0801042E, 0xDFF61081, 0x08010E4E, 0x00400000,
                    0x08010E4F, 0x00000000, 0x08010E50, 0x00000000,
                    0x08010E53, 0x00000000, 0x08010E54, 0x00000000,
                    0x08010E27, 0x00000000, 0x0801042E, 0xDFF61100,
                    0x08010429, 0x00000000, 0x08010E03, 0x00000C23,
                    0x08010E03, 0x00000C23
                }
    }


};

static chipCmdData*
gcQuerychipCmdDB(
    gctUINT32 CustomerID,
    gctUINT32 ChipID,
    gctUINT32 ChipVersion,
    gctUINT32 ProductID,
    gctUINT32 EcoID
    )
{
    gctINT entryNum = sizeof(chipcmd) / sizeof(chipcmd[0]);
    gctINT i;

    /* check formal release entries first */
    for (i = 0; i < entryNum; ++i)
    {
        if ((chipcmd[i].customerID == CustomerID)
            && (chipcmd[i].ChipID == ChipID)  /*chipmodel*/
            && (chipcmd[i].ChipVersion == ChipVersion)
            && (chipcmd[i].ProductID == ProductID)
            && (chipcmd[i].EcoID == EcoID)
            && (chipcmd[i].formalRelease))
        {
            return &chipcmd[i];
        }
    }

    for (i = 0; i < entryNum; ++i)
    {
        if ((chipcmd[i].customerID == CustomerID)
            && (chipcmd[i].ChipID == ChipID)
            && ((chipcmd[i].ChipVersion & 0xFFF0) == (ChipVersion & 0xFFF0))
            && (chipcmd[i].ProductID == ProductID)
            && (chipcmd[i].EcoID == EcoID)
            && (!chipcmd[i].formalRelease))
        {
            return &chipcmd[i];
        }
    }
    return gcvNULL;
}

#endif

